<?php
// Exit if accessed directly
if( !defined('ABSPATH') ) exit;

use Hybridauth\Exception\Exception;
use Hybridauth\Hybridauth;
use Hybridauth\HttpClient;
use Hybridauth\Storage\Session;

/**
 * Yahoo Class
 *
 * Handles all yahoo functions 
 *
 * @package Easy Digital Downloads - Social Login
 * @since 1.0.0
 */
if (!class_exists('EDD_Slg_Social_Yahoo')) {

    class EDD_Slg_Social_Yahoo {

        var $yahoo;

        public function __construct() {
            add_action('wp_logout', array($this, 'edd_slg_yahoo_logout'));
        }
        
        
        /**
         * Yahoo Logout while disconnect service
         * 
         * @package Easy Digital Downloads - Social Login
         * @since 1.0.0
         */
        public function edd_slg_yahoo_logout() {
            
            global $edd_options;

            $edd_domain_url = EDD_SLG_YH_REDIRECT_URL;
            $yahoo = $this->edd_slg_load_yahoo();

            if (!$yahoo)
                return false;
            
            $config = [
                'callback' => $edd_domain_url,
                'providers' => [
                    'yahoo' => [
                        'enabled' => true,
                        'keys' => [
                            'key' => $edd_options['edd_slg_yh_consumer_key'],
                            'secret' => $edd_options['edd_slg_yh_consumer_secret'],
                        ],
                        'scope' => 'profile,email',
                    ],
                ],
            ];
            
            $hybridauth = new Hybridauth($config);
            
            $adapter = $hybridauth->getAdapter('yahoo');
            $adapter->disconnect();
        }

        /**
         * Include Yahoo Class
         * 
         * Handles to load yahoo class
         * 
         * @package Easy Digital Downloads - Social Login
         * @since 1.0.0
         */
        public function edd_slg_load_yahoo() {

            global $edd_options;

            //yahoo declaration
            if (!empty($edd_options['edd_slg_enable_yahoo']) && !empty($edd_options['edd_slg_yh_consumer_key']) && !empty($edd_options['edd_slg_yh_consumer_secret'])) {

                require_once ( EDD_SLG_SOCIAL_LIB_DIR . '/yahoo/src/autoload.php' );

                return true;
            } else {

                return false;
            }
        }

        /**
         * Initializes Yahoo API
         * 
         * @package Easy Digital Downloads - Social Login
         * @since 1.0.0
         */
        public function edd_slg_initialize_yahoo() {
            global $edd_options;
            $edd_domain_url = EDD_SLG_YH_REDIRECT_URL;
            $yahoo = $this->edd_slg_load_yahoo();
            
            if (!$yahoo)
                return false;
            
            $config = [
                'callback' => $edd_domain_url,
                'providers' => [
                    'yahoo' => [
                        'enabled' => true,
                        'keys' => [
                            'key' => $edd_options['edd_slg_yh_consumer_key'],
                            'secret' => $edd_options['edd_slg_yh_consumer_secret'],
                        ],
                        'scope' => 'openid',
                    ],
                ],
            ];
            
            $hybridauth = new Hybridauth($config);
            $storage = new Session();
            $error = false;

            if (isset($_GET['provider'])) {
                // Validate provider exists in the $config
                if (in_array($_GET['provider'], $hybridauth->getProviders())) {
                    // Store the provider for the callback event
                    $storage->set('provider', $_GET['provider']);
                } else {
                    $error = $_GET['provider'];
                }

                $hybridauth->authenticate('yahoo');
                $adapter = $hybridauth->getAdapter('yahoo');
            }
            
            //check yahoo is enable,consumer key not empty,consumer secrets not empty and app id should not empty
            if (isset($_GET['code']) && $storage->get('provider') == 'yahoo' ) {

                $hybridauth->authenticate('yahoo');
                $storage->set('provider', null);
                $adapter = $hybridauth->getAdapter('yahoo');
                $userProfile = $adapter->getUserProfile();
                $accessToken = $adapter->getAccessToken();

                if (!empty($userProfile)) {
                    $user_data = array(
                        'profile' => array(
                            'identifier' => $userProfile->identifier,
                            'email' => $userProfile->email,
                            'first_name' => $userProfile->firstName,
                            'last_name' => $userProfile->lastName,
                            'photoURL' => strtok($userProfile->photoURL, '?'),
                            'gender' => $userProfile->gender,
                        )
                    );

                    if (isset($user_data['profile']) && !empty($user_data['profile'])) {
                        EDD()->session->set('edd_slg_yahoo_user_cache', $user_data['profile']);
                    }
                }
            }

        }

        /**
         * Get auth url for yahoo
         *
         * @param Easy Digital Downloads - Social Login
         * @since 1.0.0
         */
        public function edd_slg_get_yahoo_auth_url() {
            
            //load yahoo class
            $yahoo = $this->edd_slg_load_yahoo();

            if (!$yahoo)
                return false;

            $home_url = get_site_url();

            $url = $home_url . "/?provider=yahoo";

            return $url;
        }

        /**
         * Get Yahoo user's Data
         * 
         * @param Easy Digital Downloads - Social Login
         * @since 1.0.0
         */
        public function edd_slg_get_yahoo_user_data() {

            $user_profile_data = '';

            $user_profile_data = EDD()->session->get('edd_slg_yahoo_user_cache');

            return $user_profile_data;
        }

    }

}
?>